% ALPHA ENGINE DEFINITION
% Generated 17-Mar-2023 11:12:34

% SUGGESTED CITATION:
% Volvo 2.0L VEP LP Gen3 Miller Engine from 2020 Aachen Paper - ALPHA Map Package. Version 2023-03. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
engine = class_REVS_engine();
engine.name =  'Volvo 2.0L VEP LP Gen3 Miller Engine from 2020 Aachen Paper'; 
engine.source_filename = mfilename;
engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  1.969; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  12; 
engine.bore_mm =  82; 
engine.stroke_mm =  93.2; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	     0.0000000000000000	;     105.23058321640147	;     127.02591433175641	;     149.84290164059479	;     157.33504667550062	;     471.66458813654032	;     491.07605487024716	;     549.99155937488956	;     577.49113734363402	;     604.99071531237860		]; 
engine.full_throttle_torque_Nm = [	     0.0000000000000000	;     160.17369700000000	;     202.35731999999999	;     277.29528499999998	;     299.13151399999998	;     299.62779200000000	;     293.67245700000001	;     263.39950399999998	;     225.77100342857142	;     0.0000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	     0.0000000000000000	;     604.99071531237860		]; 
engine.naturally_aspirated_torque_Nm = [	     141.01923732657389	    141.01923732657389		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	     0.0000000000000000	;     604.99071531237860	;     733.03828583761833		]; 
engine.closed_throttle_torque_Nm = [	    -15.704266666666669	;    -38.116094740292709	;    -41.199337719599335		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	     0.0000000000000000	;     31.415926535897931	;     62.831853071795862	;     83.775804095727807	;     106.20967034509985	;     112.08419318274007	;     122.54197900906236	;     152.41596158550948	;     174.58157546693411	;     191.33516232198031	;     215.66960947439745	;     233.63289538967769	;     242.77955582791014	;     264.12294605477280	;     288.75621092819580	;     314.32954136874434	;     338.33846086761787	;     350.55746838131233	;     368.92327821761501	;     392.85989793879691	;     416.86976339586016	;     423.03375546301339	;     438.02561345615823	;     461.21501735004347	;     486.21786708971979	;     513.24842582863891	;     524.45015568972190	;     544.98666056968000	;     567.52998991095660	;     573.43289211203000	;     604.99071531237860		]; 
engine.fuel_map_torque_Nm = [	    -44.844870000000007	;    -21.172435000000004	;     2.5000000000000000	;     14.091190995454546	;     25.682381990909093	;     44.296348814285714	;     55.413391076260510	;     66.530433338235298	;     82.258064499999989	;     92.908188699999982	;     104.17627061851852	;     115.44435253703705	;     135.04962787500000	;     152.17121612500000	;     155.70719600000001	;     159.80148866666667	;     173.93887960526317	;     186.32754349999999	;     198.24005149999999	;     210.90039014285713	;     218.61042166666667	;     230.29067680952380	;     249.28942025000001	;     265.68789613888896	;     286.66023364814811	;     300.63470762407405	;     314.60918160000000		]; 
engine.fuel_map_gps = [
-0.0053743548943978826	 -0.046794135665319522	 -0.073487560511730388	 -0.089068118972210966	  -0.10373769750188838	  -0.10731611135607107	  -0.11352609419558460	  -0.12838011577583788	  -0.13568219629705058	  -0.13964990706369421	  -0.14301082240458407	  -0.14382448941971074	  -0.14393302000075855	  -0.14335958192551268	  -0.14104907353474624	  -0.13739467579623665	  -0.13356522299827628	  -0.13169153588583263	  -0.12904557779217890	  -0.12630598554029096	  -0.12482938628529454	  -0.12460017956570588	  -0.12422338151080525	  -0.12451170334638322	  -0.12608432060011213	  -0.12895044480639090	  -0.13029272539336673	  -0.13290112660959891	  -0.13592388528404850	  -0.13672161010483128	  -0.14102611680195815	;
  0.051314369635379900	  0.039240086121933346	  0.028402342472895928	  0.025070553112054389	  0.027722166265762620	  0.029054749022631526	  0.031795791817155451	  0.045718801942022241	  0.062194325936765923	  0.076769749946146687	   0.10081420088148559	   0.12024358021770587	   0.13042070558745272	   0.15493317045536562	   0.18494128928341472	   0.21800700724156299	   0.25074932376419395	   0.26786086596876396	   0.29403251909020123	   0.32908515254387327	   0.36505419087751689	   0.37433307036224334	   0.39694778217682886	   0.43215369659314634	   0.47065597071581322	   0.51310483360499015	   0.53079481273471418	   0.56328921575892843	   0.59887320011120082	   0.60817091748760310	   0.65770127142757751	;
  0.094718722960937779	   0.12040592480871529	   0.14063360822669013	   0.14310808155318225	   0.16308487040769473	   0.16951846810045515	   0.18160372151381429	   0.22549249231830742	   0.26568974164036790	   0.29833593539527370	   0.34854921184857435	   0.38716793769913638	   0.40710795484081885	   0.45441908911367607	   0.51107384804872735	   0.57244719928580290	   0.63278099654470243	   0.66439025899505044	   0.71293952155006846	   0.77904953758255036	   0.84954041330763619	   0.86807363786098513	   0.91364938089004533	   0.98616905077373673	    1.0670088919075427	    1.1567471208883349	    1.1939097080066847	    1.2618017961338979	    1.3356286363504000	    1.3549173200384541	    1.4577376669831017	;
  0.097973941944018622	   0.13845469953151981	   0.17673303600331952	   0.20026858816364917	   0.23209058275497876	   0.24150130316948207	   0.25886928472208315	   0.31753452600866688	   0.36803872063355719	   0.40848331407129007	   0.46988469465316013	   0.51750085856206285	   0.54203771220069619	   0.60014003563926832	   0.66958851624786453	   0.74550021464033145	   0.81979386886804784	   0.85820084901638982	   0.91668982151601042	   0.99608246637762465	    1.0822926949579081	    1.1053344313655582	    1.1625062832022799	    1.2564968885917565	    1.3621739659640513	    1.4736942119855401	    1.5194556894178175	    1.6031609150904726	    1.6959295782733679	    1.7203358452189006	    1.8517666008860767	;
  0.094833985235573792	   0.15155178881212086	   0.20874097290562749	   0.24933363837291914	   0.29731448046112352	   0.31091852386054902	   0.33562606436465342	   0.41055950218170145	   0.47061977804494937	   0.51820521019170696	   0.58993867836974523	   0.64683849149629236	   0.67600775915778732	   0.74516809221158153	   0.82671115863442290	   0.91780564643039819	    1.0071457158826604	    1.0520369732280148	    1.1195679615119845	    1.2121372932559300	    1.3140909258637741	    1.3411892998236445	    1.4079892166031240	    1.5261857055833261	    1.6612431393918554	    1.7907741823507857	    1.8437378291525666	    1.9423783382220112	    2.0557758954628587	    2.0859014927418174	    2.2477634461955796	;
  0.080204515510909694	   0.17092173970570479	   0.26319147944783278	   0.32691776957379709	   0.39789670410690070	   0.41698722969989876	   0.45122545148178012	   0.55156492628694687	   0.62631061034841629	   0.68473147807407553	   0.77483723107306735	   0.84530347097127412	   0.88216881200370567	   0.97070567128812579	    1.0778867226230910	    1.1930240838143598	    1.3014737583520593	    1.3564807181377720	    1.4401673079337152	    1.5583994042783360	    1.6917103540664769	    1.7271235829608336	    1.8146244239565388	    1.9612890903159228	    2.1242292489017007	    2.2892338197513116	    2.3578385222637981	    2.4859358511266954	    2.6358400073508759	    2.6757341340269845	    2.8868047567250161	;
  0.072400835937369248	   0.18498486915325774	   0.29865737816492388	   0.37559677865248736	   0.45908589045084952	   0.48108033838124659	   0.52030538135992643	   0.63340302071642474	   0.71904818784329128	   0.78605292078368993	   0.88814532251078226	   0.96782563903411289	    1.0095391044306117	    1.1102588907213804	    1.2322685897319361	    1.3618955308979743	    1.4846145472807546	    1.5474910074757264	    1.6434881044105201	    1.7779500026029604	    1.9249645758500558	    1.9632629450100361	    2.0570915713580469	    2.2083732291299785	    2.3824079478590581	    2.5760727260449565	    2.6573807072362050	    2.8081973474312760	    2.9784595396736693	    3.0232734847652174	    3.2643233630158353	;
  0.066392127315048149	   0.20063508796490540	   0.33525402068970850	   0.42511218162595804	   0.52115881053559698	   0.54621764899926040	   0.59082086225186503	   0.71851605962781040	   0.81592158649654556	   0.89216146236612748	    1.0077033857995403	    1.0972436393676450	    1.1439862163564707	    1.2566464172320930	    1.3926990122628358	    1.5367450860337672	    1.6741958817844342	    1.7459451514855961	    1.8558548197813685	    2.0050659027181483	    2.1623490066706554	    2.2033597828361402	    2.3038747184326867	    2.4645133440172531	    2.6511948419874525	    2.8672674632217254	    2.9585292216033920	    3.1283219438231744	    3.3215979714432802	    3.3720707922215394	    3.6410765505181062	;
  0.062928367476832309	   0.22606126485564471	   0.38879173430210145	   0.49656366289031745	   0.61105184949753721	   0.64086649283818420	   0.69388188524720995	   0.84540284750032924	   0.96304938579070731	    1.0548206542650671	    1.1926515758944403	    1.2980839121428955	    1.3525634748407285	    1.4819567765180144	    1.6360652540907361	    1.8002998865488518	    1.9588418907320253	    2.0414212443626227	    2.1674688615501605	    2.3359818038425417	    2.5109462790752373	    2.5567984266954582	    2.6695147257094796	    2.8508788577462627	    3.0588200800059120	    3.2992213674095408	    3.4020334991263494	    3.5945208069974490	    3.8124194760352994	    3.8690668042616987	    4.1708550560533650	;
  0.064698984601640239	   0.24599666297518541	   0.42690901256291919	   0.54697634561029917	   0.67501129880181454	   0.70847886616731370	   0.76803316854277182	   0.93840742078293693	    1.0698031910017607	    1.1717246597644377	    1.3240494327937442	    1.4399213685482617	    1.4996381315109053	    1.6410537671666996	    1.8086849583704718	    1.9869404481251278	    2.1589968908926207	    2.2480937091002686	    2.3837285482393411	    2.5650396543629141	    2.7538739643477861	    2.8033424185022069	    2.9249281925074264	    3.1201602990257147	    3.3421826998070960	    3.5979943197122974	    3.7076442932747997	    3.9128351569779825	    4.1434531480885530	    4.2039959084274043	    4.5284807806492999	;
  0.070204508727739826	   0.26975707804851695	   0.46934680268475160	   0.60251560245854141	   0.74535576701078088	   0.78279123288651931	   0.84944782448234712	    1.0403799388099231	    1.1860370572117631	    1.2984208311035648	    1.4656484980085072	    1.5922976206280046	    1.6574589715600154	    1.8114604277157706	    1.9936549653599596	    2.1870710257535486	    2.3731787827619120	    2.4693512930639949	    2.6156512537381631	    2.8112641441306372	    3.0148866039610192	    3.0681091988628419	    3.1987413254992050	    3.4072382893933524	    3.6435187273091469	    3.9155735184063891	    4.0326584122802656	    4.2518304194875016	    4.4975639345013292	    4.5620877038389605	    4.9080963174447803	;
  0.080482944263746956	   0.29734336601296391	   0.51484576771686963	   0.66061847722545386	   0.81752285709310735	   0.85869984152762036	   0.93205125216974982	    1.1429389535782373	    1.3030775231895142	    1.4260857827209088	    1.6081178733127406	    1.7451312370282999	    1.8154736397965077	    1.9813657804436369	    2.1773544249098653	    2.3862099429610244	    2.5872393737334067	    2.6909822535845844	    2.8488111790767054	    3.0598565963268340	    3.2774955731566688	    3.3341643957704235	    3.4730491011041407	    3.6942961505513003	    3.9458653178298668	    4.2361467312804777	    4.3609700885156757	    4.5951490299530029	    4.8568669626408152	    4.9252621106394106	    5.2899460758488042	;
   0.11692475158122256	   0.36079612730639293	   0.60608510061544918	   0.77120154912407324	   0.94964738649581104	   0.99659360375015926	    1.0803032404180015	    1.3220512435992764	    1.5057495440667610	    1.6465068810479748	    1.8534016654700083	    2.0078556377123751	    2.0869661127516110	    2.2731783824708676	    2.4929887987584785	    2.7276341709851062	    2.9545623320668510	    3.0722161923642357	    3.2513171278028676	    3.4895123965106762	    3.7321657453168342	    3.7949331951318390	    3.9483906477214763	    4.1937116473121181	    4.4782826372394737	    4.8070313038726171	    4.9467275441465457	    5.2061515350160255	    5.4912359075649011	    5.5653812983122606	    5.9588157437921723	;
   0.17534523745761321	   0.44005696915756032	   0.70586633121393072	   0.88465328581073410	    1.0780309166784661	    1.1289618308605680	    1.2198121011412679	    1.4827138333933731	    1.6821144120012637	    1.8349055026719800	    2.0602830814483020	    2.2294271703658692	    2.3161629327958706	    2.5204199388301558	    2.7614883786875959	    3.0189550019826425	    3.2679908987841899	    3.3969036685121510	    3.5930865255157278	    3.8543817104287599	    4.1232580094593336	    4.1932101106237036	    4.3645503982246296	    4.6371924492607572	    4.9479233513431957	    5.3033978257842982	    5.4535875877261741	    5.7318221689878488	    6.0403246070739964	    6.1211899788874211	    6.5539455546599612	;
   0.18901238628973591	   0.45810906685637670	   0.72812887472191501	   0.90954775872377736	    1.1056397932074067	    1.1572862630902274	    1.2494161958472907	    1.5161615268172732	    1.7186951862879751	    1.8739727942836586	    2.1031664373214549	    2.2752953111372514	    2.3635788098981125	    2.5715149076293429	    2.8169318569725510	    3.0790319588973296	    3.3325570129567867	    3.4638270963795685	    3.6636105584331640	    3.9295978905466300	    4.2036833627937202	    4.2750732641679088	    4.4500323765066589	    4.7285880481852276	    5.0450628196310880	    5.4063337054645695	    5.5590396019277071	    5.8420265203358888	    6.1561547921788868	    6.2385454514046712	    6.6798842651757555	;
   0.20507746764533658	   0.47927178585781122	   0.75417282150232123	   0.93861618166581040	    1.1377953251169330	    1.1902529927307683	    1.2838324794350595	    1.5549173744293650	    1.7610867093078444	    1.9192485857822383	    2.1528619557857054	    2.3284403078821070	    2.4185121897880495	    2.6307007236859348	    2.8811469653579951	    3.1485944783118072	    3.4072863991089282	    3.5412582830606270	    3.7451436216026925	    4.0166221329119596	    4.2967336970164176	    4.3697775011040898	    4.5489028002100733	    4.8342809830063382	    5.1575130260994362	    5.5256038971522177	    5.6812989047361198	    5.9699386881238539	    6.2907128553818099	    6.3748954551812176	    6.8262527524761554	;
   0.26481327511310521	   0.55713400252297940	   0.84925525967114646	    1.0439679147057579	    1.2529744829221847	    1.3079322694691491	    1.4059648767691180	    1.6899959947105347	    1.9086079911718326	    2.0767391437334419	    2.3255814467710483	    2.5129708704668765	    2.6091611538162165	    2.8358977366052573	    3.1035558521607669	    3.3890525764126931	    3.6647185161115008	    3.8073452695246273	    4.0243692353904423	    4.3144402732989349	    4.6158826624184792	    4.6945962653525362	    4.8877588310612818	    5.1958836375293558	    5.5442489132791044	    5.9397111384917087	    6.1072059840236310	    6.4183068092782030	    6.7646226789287125	    6.8555532796271574	    7.3434596113409700	;
   0.32126187664494166	   0.63074591679485237	   0.93982135912687159	    1.1453842366497180	    1.3651151192899385	    1.4226127807778057	    1.5249533954869539	    1.8171138216565208	    2.0438604312113622	    2.2194481655136888	    2.4809717670947018	    2.6785427396138308	    2.7799977653545254	    3.0191525981048191	    3.3011157925578050	    3.6014225809336500	    3.8913332855016982	    4.0413049624004191	    4.2695030803012068	    4.5747942107664787	    4.8933118231772248	    4.9766277703072923	    5.1812071553619203	    5.5085111071263677	    5.8815403947351221	    6.3086703273173361	    6.4896285582386461	    6.8252592528261387	    7.1980391897670088	    7.2959190930936932	    7.8211975718244826	;
   0.37632183135450226	   0.70312944175948067	    1.0295269261283362	    1.2464491750582201	    1.4777070868786684	    1.5379941892197229	    1.6451188872374507	    1.9460578922720195	    2.1792772955108513	    2.3617144728275647	    2.6353115374782830	    2.8423640430498329	    2.9486571593088549	    3.1989852510254568	    3.4933064822257713	    3.8070503158924605	    4.1113972681382158	    4.2689573757949928	    4.5085991346523251	    4.8288051882311844	    5.1627144982274409	    5.2500642937044040	    5.4645760120573410	    5.8084250411442424	    6.2049585203302620	    6.6667476385083839	    6.8626034967432776	    7.2256975405200121	    7.6276129253107063	    7.7330470600059913	    8.2981369659795643	;
   0.43339390923977844	   0.77913363270596403	    1.1241545911672279	    1.3530717823548453	    1.5967564887226782	    1.6602421578464492	    1.7730148906159549	    2.0882932435650940	    2.3298753634587217	    2.5204962945597309	    2.8065691227728808	    3.0225445145705319	    3.1332412550040676	    3.3933596887260613	    3.6990018012912889	    4.0272218616678259	    4.3483230299178759	    4.5149185908916758	    4.7680955679315291	    5.1052387756161357	    5.4561229821218440	    5.5479192707066938	    5.7733874023004903	    6.1354602612313052	    6.5556424507399162	    7.0546294037948858	    7.2670583576873113	    7.6612544345569464	    8.0954061376426836	    8.2091101134436038	    8.8170192984382787	;
   0.46668216323190248	   0.82409245319043012	    1.1805082821252129	    1.4166822932594338	    1.6677929156112821	    1.7332056515286258	    1.8494335116022158	    2.1774563950855206	    2.4264566875480549	    2.6214828988342287	    2.9140506882291732	    3.1349261914807895	    3.2481043076791161	    3.5138798163057383	    3.8261745847904902	    4.1623023227557461	    4.4930232822594398	    4.6653395540739542	    4.9278400372914133	    5.2766368198151596	    5.6390744562469708	    5.7338930847061427	    5.9667914923744618	    6.3408462610564174	    6.7750919574339150	    7.2963073762799864	    7.5185599835058268	    7.9307517679526391	    8.3833474796151126	    8.5017217252680677	    9.1333754478258271	;
   0.51460360172916797	   0.88989119006247630	    1.2637881142259979	    1.5112431967883777	    1.7744261172418243	    1.8431190918761649	    1.9652851232861395	    2.3129823529897036	    2.5752514640143964	    2.7782539829655417	    3.0804608450774542	    3.3082878479709072	    3.4251020854421355	    3.6997759644039481	    4.0257840183387126	    4.3799477482825910	    4.7173569145303773	    4.8953207666025165	    5.1713484740486440	    5.5401386361756346	    5.9224469915323814	    6.0224220352400453	    6.2679516737042418	    6.6622933044670285	    7.1206093963815178	    7.6719572505035254	    7.9077304661308565	    8.3452398598795128	    8.8216761622170736	    8.9461122349730697	    9.6092095572817371	;
   0.58124915218311557	   0.98667358375418779	    1.3914582242059395	    1.6605472933626768	    1.9479825686008376	    2.0231466660038770	    2.1568959650302988	    2.5383450197476809	    2.8228094288805967	    3.0393170788949067	    3.3576652159159366	    3.5974356884157013	    3.7207026589297425	    4.0119600001218183	    4.3587784901876221	    4.7408328419356627	    5.1044559958867755	    5.2912683957798006	    5.5855012528520183	    5.9868119070508605	    6.4080368168653763	    6.5184671960210245	    6.7899084305176496	    7.2255860958486950	    7.7262322537946400	    8.3111649875374347	    8.5595542975086438	    9.0195720525965282	    9.5218683098566022	    9.6530100080386436	    10.351562941900417	;
   0.62885755724996351	    1.0610211768854767	    1.4936498647431991	    1.7827405561052208	    2.0931235907034096	    2.1744775634403388	    2.3193334331268320	    2.7326000926715670	    3.0321475497752588	    3.2582888320399475	    3.5928150262392409	    3.8461657637871269	    3.9766341815135440	    4.2855858354994218	    4.6553705433441328	    5.0563587165969253	    5.4442315033545183	    5.6486134239074159	    5.9629174095647892	    6.3924845260917156	    6.8485773548521358	    6.9681881680578934	    7.2621009264433578	    7.7316051127083680	    8.2619638261878698	    8.8613622022850027	    9.1137188614103053	    9.5800326336938166	    10.093258569632749	    10.227564821135669	    10.945031608420042	;
   0.68227802120474801	    1.1478909638464700	    1.6141233620518485	    1.9254951517997014	    2.2593874999021084	    2.3468263143326475	    2.5024752408698627	    2.9463183718225809	    3.2714548871697278	    3.5184220481341058	    3.8859300148034848	    4.1649023354755919	    4.3085666249668648	    4.6486477149827028	    5.0546127420009341	    5.4900616216586053	    5.9121424482939897	    6.1338741270186645	    6.4755418856999158	    6.9422603369346714	    7.4348989676727086	    7.5635073172243823	    7.8787523603462644	    8.3774330318065449	    8.9303633305811569	    9.5422139143920859	    9.7979892060317280	    10.269207778428623	    10.789297504880892	    10.925613392013352	    11.655282737868413	;
   0.71692645521047649	    1.2028756948225769	    1.6891861520899356	    2.0136951609762708	    2.3614771524801177	    2.4525584017237247	    2.6147100360518785	    3.0783685915104102	    3.4251680204139445	    3.6901731451523379	    4.0826320124218052	    4.3794264560188383	    4.5321370355185886	    4.8932844043287629	    5.3231468783026470	    5.7856563361760376	    6.2360714252470020	    6.4717950665580206	    6.8333607488283175	    7.3221369748342502	    7.8330096975766246	    7.9659727625806687	    8.2914221726670068	    8.8038530886680153	    9.3680854172213195	    9.9883011626508544	    10.246870133393625	    10.722513594156482	    11.246709626597713	    11.384077891598654	    12.119248836435659	;
   0.75153107249409290	    1.2568830389199572	    1.7622655493567960	    2.0995309315235677	    2.4615166895082794	    2.5564887494115034	    2.7256873326343847	    3.2121267395303210	    3.5802443003493338	    3.8624049228349397	    4.2795052149184887	    4.5940536592170860	    4.7557547635264781	    5.1378318189751626	    5.5925904681411698	    6.0836749549281164	    6.5636505864008781	    6.8133031110201925	    7.1942917752368487	    7.7046291601174399	    8.2326396740420531	    8.3696011112342781	    8.7043136841411144	    9.2289915214230298	    9.8036152847412072	    10.432401385704351	    10.693952786995355	    11.174404935973469	    11.702903555069719	    11.841340655955616	    12.581800375884379	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel;
engine.fuel.description =  'Estimated Volvo 2.0L VEP LP Gen3 Miller Engine test fuel derived from the Aachen paper'; 
engine.fuel.density_kgpL_15C =  0.74008883199999997; 
engine.fuel.energy_density_MJpkg =  42.1; 
engine.fuel.research_octane_number =  98; 
engine.fuel.alcohol_pct_vol =  0; 

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	     68.067840827778852	    68.067840827778852		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
